document.addEventListener('DOMContentLoaded', () => {
    const root = document.querySelector('.countdown__list');
    if (!root) return;

    const HORAS = 3;
    const MINUTOS = 2;
    const SEGUNDOS = 15;

    const DURATION = HORAS * 3600 + MINUTOS * 60 + SEGUNDOS; // duração total em segundos
    const KEY = 'countdownStartTime';

    let start = Number(localStorage.getItem(KEY));
    if (!start) {
        start = Date.now();
        localStorage.setItem(KEY, String(start));
    }

    const hoursEls = root.children[0].querySelectorAll('.countdown__digit');
    const minutesEls = root.children[1].querySelectorAll('.countdown__digit');
    const secondsEls = root.children[2].querySelectorAll('.countdown__digit');

    const setDigits = (els, value) => {
        const s = String(value).padStart(2, '0');
        els[0].textContent = s[0];
        els[1].textContent = s[1];
    };

    const tick = () => {
        const elapsed = Math.floor((Date.now() - start) / 1000);
        const left = Math.max(0, DURATION - elapsed);

        setDigits(hoursEls, Math.floor(left / 3600));
        setDigits(minutesEls, Math.floor((left % 3600) / 60));
        setDigits(secondsEls, left % 60);

        if (left === 0) clearInterval(timer);
    };

    const timer = setInterval(tick, 1000);
    tick();
});
